#ifdef _VERSION_CHECK_
	#ifndef MSET

		#ifndef _NOT_INSTANCED_
		
			//#version 120
			#extension GL_EXT_gpu_shader4 : enable          
			
		#endif
		
	#endif
#endif

// vertex attributes
attribute vec3 			s2_vertex;
attribute vec3			s2_normal;
attribute vec4 			s2_color;
attribute vec4 			s2_secondaryColor;
attribute vec4			s2_texcoords; 
attribute vec4			s2_binormal; 

#ifdef ALPHATEST

	#ifdef BSET
		uniform float 		fade;
	#endif
	varying float		alphaFade;

	#ifdef VEGETATION
		uniform float 	windStrenght;
		uniform vec3 	windVec;
		uniform float	time;
		uniform vec2 	meshbox;
		uniform vec2	bendMul;
		float 			freq=time;
		
		#ifndef BSET
			#ifndef MSET
				uniform float	hueVariation;
				varying vec3	vgColor;
			#endif
		#endif
	#endif
				
#endif

#ifdef LAYER1
	
	uniform sampler2D 	dif1;
	varying vec3		vertColor;
	uniform vec2		dofs1;
	uniform vec2		dscale1;
	uniform vec4		dcolor1;
	
#endif 

#ifdef _HEIGHTMAP_
	
	uniform sampler2D	heightmap;
	uniform vec2		invHeightmapSize;
	uniform vec2		tileDim;
	uniform vec3		terrainDim; // width, depth and height of the terrain
 	uniform vec3		invTerrainDim;
	
	uniform vec3		WorldPoses[200];

	uniform vec2		baseTiles;
	uniform vec3		baseTexParams;
	varying mat3		TBN;
	varying float		vSlope;
	varying vec2		baseCoords;
	uniform float		terrainNormOrg;
	
#else

	#ifdef SKINNING
	
		uniform samplerBuffer 	boneMatrices;
		uniform samplerBuffer 	prevBoneMatrices;

		varying mat3	TBN;
		
		#ifdef BONES_8
			attribute vec4			S2_texcoords2_Array;
			attribute vec4			S2_texcoords3_Array;
		#endif
						
	#else
	
		#ifdef PSYSTEM

			uniform	vec4 	pparams[100]; 
			uniform vec4	prevPParams[100];
			
			vec4			tpos;
			uniform vec4	data;

			varying float 	life;

			uniform vec2	tofs;			// cambiare in uniform
			uniform vec2	tscale;
			varying float	cosa,
							sina;
			uniform vec4 	particleScale; //particleScale.w start rotation
	
		#else

			#ifdef BSET

				uniform 		samplerBuffer 	pparams;
				vec4			tpos;
				uniform vec4	data;
				varying vec4	pnormal;
				varying vec4 	pcolor;
				
				uniform vec3	campos;
				
			#else
	
				#ifdef MSET

					uniform	mat4 	pparams[60];
					
					vec4			tpos;
					varying vec4 	pcolor;
				#else
				
					#ifndef _NOT_INSTANCED_
					
						uniform samplerBuffer 		WorldPoses;
						uniform samplerBuffer 		prevWorldPoses;
					
					#endif
					
					varying float occlusion; 
					
				#endif
		
				varying mat3	TBN;

			#endif

		#endif
						
	#endif
	
#endif

varying float			scatterMask;
uniform sampler2D		thickness;
varying vec2 			texcoord;
					
vec4 					outNormal,
						outTangent,
						outBinormal; 

varying vec4 	curpos,
#ifdef _HEIGHTMAP_
				pos,
#endif				
				prev;
uniform mat4	prevMVM,
				prevWTM;
uniform vec2	NF;

vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

vec4 SmoothCurve( vec4 x ) {
  return x * x *( 3.0 - 2.0 * x );
}

vec4 TriangleWave( vec4 x ) {
  return abs( fract( x + 0.5 ) * 2.0 - 1.0 );
}

vec4 SmoothTriangleWave( vec4 x ) {
  return SmoothCurve( TriangleWave( x ) );
}

vec2 XformWind(vec2 wind, mat4 TM)
{
	mat2 TM2;
	TM2[0]=vec2(TM[0].x,TM[2].x);
	TM2[1]=vec2(TM[0].z,TM[2].z);
	return TM2*wind;
}

void main()
{	
		
#ifdef _HEIGHTMAP_

	// compute position basing on heightmap
	vec4 	position00,
			position10,
			position01;
		
	mat4 MTX;
	vec3 tilepos=WorldPoses[gl_InstanceID];
	texcoord = ((s2_vertex.xz + tilepos.xz)*invTerrainDim.xz)+vec2(0.5,0.5)+(invHeightmapSize*0.5);
	position00.y=(texture2D(heightmap,texcoord.st).x-terrainNormOrg)*terrainDim.y;
	position00.xz=s2_vertex.xz;
	position10.y=(texture2D(heightmap,texcoord.st + vec2(invHeightmapSize.x,0.0)).x-terrainNormOrg)*terrainDim.y;
	position10.xz=s2_vertex.xz + vec2(tileDim.x,0.0);
	position01.y=(texture2D(heightmap,texcoord.st + vec2(0.0,invHeightmapSize.y)).x-terrainNormOrg)*terrainDim.y;
	position01.xz=s2_vertex.xz + vec2(0.0,tileDim.y);
	
	vec4 position;
	position.xyz=tilepos+position00.xyz;
	position.w=1.0;
	
	// transform position in projection and eye space
	gl_Position = gl_ModelViewProjectionMatrix * position;
	pos=gl_ModelViewMatrix*position;
	
	// compute previous position for motion blur
	mat4 MVP=gl_ProjectionMatrix*prevMVM;
	prev=MVP*position;
	
	curpos=gl_Position;
	vSlope=abs(dot(normal3,vec3(0.0,1.0,0.0)));
	vSlope=clamp( (vSlope-baseTexParams.x)*baseTexParams.z, 0.0,1.0);
	vSlope*=1.0 - clamp( ((position.y*invTerrainDim.y)-baseTexParams.y)*100.0, 0.0,1.0);
	baseCoords=texcoord.st*baseTiles;
	
#else

	#ifdef SKINNING

		vec4 index  		= s2_secondaryColor;
		vec4 weight 		= s2_color;
		vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
		vec4 vertex			= vec4(s2_vertex,1.0);
		vec4 prevpos 		= vec4( 0.0, 0.0, 0.0, 0.0 );
		
		mat4 TM=mat4(	0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,1.0);
		mat4 pTM=mat4(	0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,1.0);

		int j;
		for( int i = 0; i < 4; i++ )
		{
			// Apply influence of bone i
			j=int(index[i]*4);
			TM[0].xyz=texelFetchBuffer(boneMatrices,j).xyz;
			TM[1].xyz=texelFetchBuffer(boneMatrices,j+1).xyz;
			TM[2].xyz=texelFetchBuffer(boneMatrices,j+2).xyz;
			TM[3].xyz=texelFetchBuffer(boneMatrices,j+3).xyz;
			
			pTM[0].xyz=texelFetchBuffer(prevBoneMatrices,j).xyz;
			pTM[1].xyz=texelFetchBuffer(prevBoneMatrices,j+1).xyz;
			pTM[2].xyz=texelFetchBuffer(prevBoneMatrices,j+2).xyz;
			pTM[3].xyz=texelFetchBuffer(prevBoneMatrices,j+3).xyz;
			
			position = position + (TM * vertex) *weight[i];
			prevpos = prevpos + ( (pTM*vertex) * weight[i] );
		}
		
		#ifdef BONES_8
			index 	= S2_texcoords3_Array;
			weight 	= S2_texcoords2_Array;
			for( int i = 0; i < 4; i++ )
			{
				// Apply influence of bone i
				j=int(index[i]*4);
				TM[0].xyz=texelFetchBuffer(boneMatrices,j).xyz;
				TM[1].xyz=texelFetchBuffer(boneMatrices,j+1).xyz;
				TM[2].xyz=texelFetchBuffer(boneMatrices,j+2).xyz;
				TM[3].xyz=texelFetchBuffer(boneMatrices,j+3).xyz;
				
				pTM[0].xyz=texelFetchBuffer(prevBoneMatrices,j).xyz;
				pTM[1].xyz=texelFetchBuffer(prevBoneMatrices,j+1).xyz;
				pTM[2].xyz=texelFetchBuffer(prevBoneMatrices,j+2).xyz;
				pTM[3].xyz=texelFetchBuffer(prevBoneMatrices,j+3).xyz;
				
				position = position + (TM * vertex) *weight[i];
				prevpos = prevpos + ( (pTM*vertex) * weight[i] );
			}
		#endif
		
		gl_Position = gl_ModelViewProjectionMatrix * position;
		prevpos=prevMVM*prevpos;
		prev = gl_ProjectionMatrix*prevpos;	

		texcoord = s2_texcoords.st;
		curpos=gl_Position;	
		
	#else

		#ifdef PSYSTEM

			vec4 index=s2_color;
			vec4 ppos=pparams[int(index.x)];
			life=clamp(ppos.w,0.0,1.0);
			float scale=data.x + (data.y*(1.0-life));
			scale=clamp(scale,0.0,abs(scale))*0.5;
			scale+=scale*index.y;	
			ppos.w=1.0;

			float angle=(index.y*6.28+particleScale.w)+(data.z*(1.0-life)*6.28);

			cosa=cos(angle);
			sina=sin(angle);

			tpos=gl_ModelViewMatrix * ppos;	
			
			vec3 tv=s2_vertex;
			tv.x=(s2_vertex.x*cosa)-(s2_vertex.y*sina);
			tv.y=(s2_vertex.x*sina)+(s2_vertex.y*cosa);
			tpos.xyz=(tv.xyz*particleScale.xyz*scale + tpos.xyz);

			gl_Position=gl_ProjectionMatrix*tpos;
			texcoord = s2_texcoords.st*tscale;

			curpos=gl_Position;		
			
			ppos=prevPParams[int(index.x)];
			scale=data.x + (data.y*(1.0-life));
			scale=clamp(scale,0.0,abs(scale))*0.5;
			scale+=scale*index.y;	
			ppos.w=1.0;

			tpos=prevMVM*ppos;	
			tpos.xyz=(tv.xyz*scale + tpos.xyz);
			prev=gl_ProjectionMatrix*tpos;
			
		#else

			#ifdef BSET

				vec4 index=s2_color;
				int i=int(index.x)*3;
				vec4 ppos;
				ppos=texelFetchBuffer(pparams,i);
				pcolor=texelFetchBuffer(pparams,i+1);	
				
				////////////////////////////////////////////
				float bend=pcolor.w*s2_vertex.y;
				vec4 newpos=vec4(s2_vertex,1.0);
				#ifdef VEGETATION
					float vlen=length(newpos.xyz);
					float phase=dot(ppos.xyz,vec3(1.0,1.0,1.0));
					newpos.x+=(sin( (freq*5.2)+phase)*0.4 + cos((freq*8.5)+2.0*phase)*0.2 )*bend*bendMul.x*windStrenght;
					newpos.xyz=normalize(newpos.xyz)*vlen;
				#endif
				//////////////////////////////////////
				
				ppos.w=1.0;
				
				vec4 normal4 = vec4( s2_normal, 0.0 );
				normal4=texelFetchBuffer(pparams,i+2);
				float scale=abs(normal4.w)*0.5*index.y;
				
				mat3 PTM;
				PTM[2]=normalize(ppos.xyz-campos);
				PTM[0]=normalize(cross(vec3(0.0,1.0,0.0),PTM[2]));
				PTM[1]=cross(PTM[2],PTM[0]);
				
				vec4 rpos=newpos*scale;
				rpos.xyz=(PTM*rpos.xyz) + ppos.xyz;
				rpos.w=1.0;
				
				tpos=gl_ModelViewMatrix*rpos;
				gl_Position=gl_ProjectionMatrix*tpos;	
				curpos=gl_Position;	
				
				// compute prev pos
				tpos=prevMVM*rpos;
				prev=gl_ProjectionMatrix*tpos;
				
				texcoord = s2_texcoords.st;	
		
			#else
			
				#ifdef MSET
					
					vec4 index=s2_color;
					mat4 mtx=pparams[int(index.w)];
					float bendScale=mtx[3].w;
					mtx[3].w=1.0;
					vec4 newpos=vec4(s2_vertex,1.0);
					
					#ifdef VEGETATION
						////////////////////////////////////////////
						float phase=dot(mtx[3].xyz,vec3(1.0,1.0,1.0));
						phase+=freq;
						vec2 	windMul=sin( vec2(phase, ((phase+1.0)*5.0)+1.570796) );
						
						float vlen=length(s2_vertex);
						float bend;
						bend=s2_vertex.y*bendScale;
						bend += 1.0;
						bend = (bend * bend - bend) * bendMul.x * windStrenght;
						
						vec2 windVector=windVec.xz;
						mtx[0].w=0.0;
						mtx[1].w=0.0;
						mtx[2].w=0.0;
					
						newpos.xz+=( XformWind(windVector,mtx)*((windMul.x+windMul.y)*10.0+30.0) *bend );
						newpos.xyz=normalize(newpos.xyz)*vlen;
						//////////////////////////////////////
					#else
						mtx[0].w=0.0;
						mtx[1].w=0.0;
						mtx[2].w=0.0;
					#endif
					
					newpos=mtx*newpos;
					tpos=gl_ModelViewMatrix * newpos;	
					gl_Position=gl_ProjectionMatrix*tpos;	
					curpos=gl_Position;	
					
					// compute prev pos
					tpos=prevMVM*newpos;	
					prev=gl_ProjectionMatrix*tpos;
		
					texcoord = s2_texcoords.st;	
					
				#else

					occlusion=s2_color.a;
			
					#ifndef _NOT_INSTANCED_
					
						mat4 MTX;
						int index=gl_InstanceID*4;
						MTX[0]=texelFetchBuffer(WorldPoses,index);
						MTX[1]=texelFetchBuffer(WorldPoses,index+1);
						MTX[2]=texelFetchBuffer(WorldPoses,index+2);
						MTX[3]=texelFetchBuffer(WorldPoses,index+3);
						
						#ifdef ALPHATEST
							alphaFade=MTX[3].w+0.01;
							MTX[3].w=1.0;
						#endif
						
						mat4 prevMTX;
						prevMTX[0]=texelFetchBuffer(prevWorldPoses,index);
						prevMTX[1]=texelFetchBuffer(prevWorldPoses,index+1);
						prevMTX[2]=texelFetchBuffer(prevWorldPoses,index+2);
						prevMTX[3]=texelFetchBuffer(prevWorldPoses,index+3);
						
						vec4 newpos=vec4(s2_vertex,1.0);
						vec4 worldPos;
						
						#ifdef VEGETATION
						
							float vlen=length(s2_vertex);	
							float bend;
							bend=s2_vertex.y*meshbox.y;
							bend += 1.0;
							bend = (bend * bend - bend) * bendMul.x * windStrenght;
							
							vec2 windVector=vec2(MTX[1].w,MTX[2].w);
							MTX[1].w=0.0;
							MTX[2].w=0.0;
							newpos.xz+=(XformWind(windVector,MTX)*bend);
							newpos.xyz=normalize(newpos.xyz)*vlen;
							
							//////////////////////////////////////
						#else	
							MTX[1].w=0.0;
							MTX[2].w=0.0;
						#endif
					
						worldPos=MTX*newpos;
						gl_Position = (gl_ModelViewProjectionMatrix)*worldPos;
				
						worldPos=prevMTX*newpos;
						worldPos=prevMVM*worldPos;
						prev=gl_ProjectionMatrix*worldPos;
						texcoord = s2_texcoords.st;		
						curpos=gl_Position;
					
					#else
						vec4 newpos=vec4(s2_vertex,1.0);
					
						#ifdef VEGETATION
							float vlen=length(s2_vertex);			
							float bend;
							bend=s2_vertex.y*meshbox.y;
							bend += 1.0;
							bend = (bend * bend - bend) * bendMul.x * windStrenght;
							
							vec2 windVector=windVec.xz;
							newpos.xz+=(XformWind(windVector,prevWTM)*bend);
							newpos.xyz=normalize(newpos.xyz)*vlen;
						#endif
						
						gl_Position = (gl_ModelViewProjectionMatrix)*newpos;//ftransform();
						
						newpos=prevWTM*newpos;
						newpos=prevMVM*newpos;
						prev=gl_ProjectionMatrix*newpos;
						texcoord = s2_texcoords.st;		
						curpos=gl_Position;
						
					#endif
					
				#endif
			
			#endif
			
		#endif
		
	#endif
	
#endif

}